<?php
$host = "127.0.0.1";
$port = 5038;
$username = "instacall";
$password = "instacall123";

// Connect to AMI
$socket = fsockopen($host, $port, $errno, $errstr, 10);
if (!$socket) {
    die("Connection failed: $errstr ($errno)\n");
}

// AMI Login
fputs($socket, "Action: Login\r\n");
fputs($socket, "Username: $username\r\n");
fputs($socket, "Secret: $password\r\n\r\n");

// Get active calls
fputs($socket, "Action: Command\r\n");
fputs($socket, "Command: core show channels verbose\r\n\r\n");

// Read response
$response = "";
while (!feof($socket)) {
    $line = fgets($socket, 1024);
    if (trim($line) == "--END COMMAND--") break; // Stop at end of response
    $response .= $line;
}

// Logout & close connection
fputs($socket, "Action: Logoff\r\n\r\n");
fclose($socket);

// Extract call details
$calls = [];
$lines = explode("\n", $response);
foreach ($lines as $line) {
    if (preg_match('/(\S+@\S+)\s+(\S+)\s+(\S+)\s+\((\d+)\)\s+(.*?)\s+(\S+@\S+)/', $line, $matches)) {
        $calls[] = [
            'caller' => $matches[1],
            'callee' => $matches[6],
            'channel' => $matches[2],
            'state' => $matches[5],
            'duration' => $matches[4]
        ];
    }
}

// Display live call details in table
echo "<h2>Live Calls</h2>";
echo "<table border='1' cellspacing='0' cellpadding='5'>";
echo "<tr><th>Caller</th><th>Callee</th><th>Channel</th><th>State</th><th>Duration (sec)</th></tr>";
foreach ($calls as $call) {
    echo "<tr>
        <td>{$call['caller']}</td>
        <td>{$call['callee']}</td>
        <td>{$call['channel']}</td>
        <td>{$call['state']}</td>
        <td>{$call['duration']}</td>
    </tr>";
}
echo "</table>";
?>
