<?php
$recording_dir = "/var/spool/asterisk/monitor/";
$recordings = [];

// Get all recording files
foreach (glob($recording_dir . "call_*.wav") as $file) {
    $recordings[] = [
        'name' => basename($file),
        'size' => filesize($file),
        'modified' => filemtime($file)
    ];
}

// Sorting
$sort = isset($_GET['sort']) ? $_GET['sort'] : 'name';
$order = isset($_GET['order']) ? $_GET['order'] : 'asc';

usort($recordings, function($a, $b) use ($sort, $order) {
    if ($order == 'asc') {
        return $a[$sort] <=> $b[$sort];
    } else {
        return $b[$sort] <=> $a[$sort];
    }
});

// Handle delete action
if (isset($_GET['delete'])) {
    $file_to_delete = $recording_dir . basename($_GET['delete']);
    if (file_exists($file_to_delete)) {
        if (unlink($file_to_delete)) {
            $message = "File deleted successfully.";
        } else {
            $message = "Failed to delete the file.";
        }
    } else {
        $message = "File not found.";
    }
    header("Location: " . $_SERVER['PHP_SELF'] . "?message=" . urlencode($message));
    exit;
}

// Handle download action
if (isset($_GET['download'])) {
    $file_to_download = $recording_dir . basename($_GET['download']);
    if (file_exists($file_to_download)) {
        header('Content-Type: audio/wav');
        header('Content-Disposition: attachment; filename="' . basename($file_to_download) . '"');
        header('Content-Length: ' . filesize($file_to_download));
        readfile($file_to_download);
        exit;
    } else {
        $message = "File not found.";
        header("Location: " . $_SERVER['PHP_SELF'] . "?message=" . urlencode($message));
        exit;
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Recorded Calls</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.7.2/font/bootstrap-icons.css" rel="stylesheet">
</head>
<body>
    <div class="container mt-5">
        <h2 class="mb-4">Recorded Calls</h2>
        
        <?php if (isset($_GET['message'])): ?>
            <div class="alert alert-info" role="alert">
                <?= htmlspecialchars($_GET['message']) ?>
            </div>
        <?php endif; ?>

        <table class="table table-striped table-hover">
            <thead>
                <tr>
                    <th>
                        <a href="?sort=name&order=<?= $sort == 'name' && $order == 'asc' ? 'desc' : 'asc' ?>">
                            File Name
                            <?php if ($sort == 'name'): ?>
                                <i class="bi bi-arrow-<?= $order == 'asc' ? 'up' : 'down' ?>"></i>
                            <?php endif; ?>
                        </a>
                    </th>
                    <th>
                        <a href="?sort=size&order=<?= $sort == 'size' && $order == 'asc' ? 'desc' : 'asc' ?>">
                            Size (bytes)
                            <?php if ($sort == 'size'): ?>
                                <i class="bi bi-arrow-<?= $order == 'asc' ? 'up' : 'down' ?>"></i>
                            <?php endif; ?>
                        </a>
                    </th>
                    <th>
                        <a href="?sort=modified&order=<?= $sort == 'modified' && $order == 'asc' ? 'desc' : 'asc' ?>">
                            Date Modified
                            <?php if ($sort == 'modified'): ?>
                                <i class="bi bi-arrow-<?= $order == 'asc' ? 'up' : 'down' ?>"></i>
                            <?php endif; ?>
                        </a>
                    </th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($recordings as $rec): ?>
                <tr>
                    <td><?= htmlspecialchars($rec['name']) ?></td>
                    <td><?= number_format($rec['size']) ?></td>
                    <td><?= date('Y-m-d H:i:s', $rec['modified']) ?></td>
                    <td>
                        <a href="?download=<?= urlencode($rec['name']) ?>" class="btn btn-sm btn-primary">
                            <i class="bi bi-download"></i> Download
                        </a>
                        <a href="?delete=<?= urlencode($rec['name']) ?>" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure you want to delete this file?')">
                            <i class="bi bi-trash"></i> Delete
                        </a>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>