<?php
$ami_host = "127.0.0.1";
$ami_port = 5038;
$ami_user = "instacall";
$ami_pass = "instacall123";

// Connect to Asterisk AMI
$socket = fsockopen($ami_host, $ami_port, $errno, $errstr, 5);
if (!$socket) {
    die("Connection failed: $errstr ($errno)");
}

// Login to AMI
fputs($socket, "Action: Login\r\n");
fputs($socket, "Username: $ami_user\r\n");
fputs($socket, "Secret: $ami_pass\r\n");
fputs($socket, "Events: off\r\n\r\n");

// Get active calls
fputs($socket, "Action: CoreShowChannels\r\n\r\n");

$active_calls = [];
while (!feof($socket)) {
    $line = fgets($socket, 1024);
    
    if (strpos($line, "Channel: ") !== false) {
        $channel = trim(substr($line, 9));
    }
    if (strpos($line, "CallerIDNum: ") !== false) {
        $caller = trim(substr($line, 13));
    }
    if (strpos($line, "ConnectedLineNum: ") !== false) {
        $connected = trim(substr($line, 18));
    }
    if (strpos($line, "Uniqueid: ") !== false) {
        $uniqueid = trim(substr($line, 9));
    }

    if (!empty($uniqueid) && !isset($active_calls[$uniqueid])) {
        $active_calls[$uniqueid] = [
            'Channel' => $channel,
            'CallerID' => $caller,
            'ConnectedTo' => $connected,
            'UniqueID' => $uniqueid
        ];
    }

    if (strpos($line, "Event: CoreShowChannelsComplete") !== false) {
        break;
    }
}

// Logout from AMI
fputs($socket, "Action: Logoff\r\n\r\n");
fclose($socket);

// Display active calls
echo "<h2>Active Calls</h2>";
if (!empty($active_calls)) {
    echo "<table border='1'>
            <tr><th>Channel</th><th>Caller ID</th><th>Connected To</th><th>Record</th></tr>";
    foreach ($active_calls as $call) {
        echo "<tr>
                <td>{$call['Channel']}</td>
                <td>{$call['CallerID']}</td>
                <td>{$call['ConnectedTo']}</td>
                <td>
                    <a href='listen.php?channel={$call['Channel']}'>Listen</a>
                </td>
                <td>
                    <button onclick=\"startRecording('{$call['Channel']}')\">Record</button>
                </td>
              </tr>";
    }
    echo "</table>";
} else {
    echo "<p>No active calls.</p>";
}
?>

<script>
function startRecording(channel) {
    fetch('record.php?channel=' + encodeURIComponent(channel))
        .then(response => response.text())
        .then(data => alert(data))
        .catch(error => alert('Error: ' + error));
}
</script>

